<?php

class UserStudentPasswordForm extends CFormModel
{
	public $emailOrPesel;
	public $password;
	public $passwordRepeat;
	public $userModel;//from validEmailOrPesel rule

	private $identity;

	public function rules()
	{
		return array(
			array('emailOrPesel', 'validEmailOrPesel','on'=>'sendEmail'),

			array('passwordRepeat', 'compare', 'compareAttribute'=>'password','on'=>'setPassword'),
			array('password', 'required','on'=>'setPassword'),
		);
	}

	public function validEmailOrPesel()
	{
		$user = Uzytkownik::model()->findByAttributes(array('email'=>$this->emailOrPesel));

		if(empty($user))
			$this->addError('emailOrPesel','Podane dane są nieprawidłowe.');
		else
			$this->userModel = $user;
	}

	public function attributeLabels()
	{
		return array(
			'emailOrPesel'=>'Podaj swój e-mail:',
			'password'=>'Podaj nowe hasło',
			'passwordRepeat'=>'Powtórz nowe hasło',
		);
	}
}
